#include <string.h>
#include <monocypher/monocypher.h>

#include "cryptodf.h"
#include "xmonocyp.h"


int check_keypair(const unsigned char secret[], const unsigned char pub[])
{
    int res;
    unsigned char secr_copy[secret_key_size];
    unsigned char gsecr[secret_key_size];
    unsigned char gpub[public_key_size];

    res = memcmp(pub, secret + (secret_key_size - public_key_size),
                 public_key_size);
    if(res != 0)
        return 0;

        /* we make a copy to avoid wiping the structure by the
           crypto_eddsa_key_pair function
         */
    memcpy(secr_copy, secret, secret_key_size);
    crypto_eddsa_key_pair(gsecr, gpub, secr_copy);
        /* this wipes the first half of secr_copy, which isn't a
           problem, as we don't need it any longer anyway; but its copy
           is made in the gsecr, which we need to wipe on our own
         */
    crypto_wipe(gsecr, sizeof(gsecr));

    res = memcmp(gpub, pub, public_key_size);
    if(res != 0)
        return 0;

    return 1;
}
