#include <string.h>

#include "txtr_out.h"

enum {
    fieldname_width = 14,
    bytes_per_line = 32
};

static void put_spaces(FILE *f, int n)
{
    int i;
    if(n < 1)
        n = 1;
    for(i = 0; i < n; i++)
        fputc(' ', f);
}

void put_hex_field(FILE *f, const char *fieldnm, const void *vb, int len)
{
    const unsigned char *buf = vb;
    int fnlen, i;

    fnlen = strlen(fieldnm);

    fputs(fieldnm, f);
    put_spaces(f, fieldname_width - fnlen);

    for(i = 0; i < len; i++) {
        fprintf(f, "%02x", buf[i]);
        if(!((i+1) % bytes_per_line)) {
            fprintf(f, "\n");
            if(i < len-1)
                put_spaces(f, fieldname_width);
        }
    }
    if(i % bytes_per_line)
        fprintf(f, "\n");
}

void put_string_field(FILE *f, const char *fieldnm, const char *str)
{
    fprintf(f, "%-*s %s\n", fieldname_width-1, fieldnm, str);
}

void put_int_field(FILE *f, const char *fieldnm, int val)
{
    fprintf(f, "%-*s %d\n", fieldname_width-1, fieldnm, val);
}
