/*
    This module implements a 16-ary tree for quick search by
    fixed-length keys.  Half-bytes of the key are used as
    indices of children as the tree is traversed node to node.
 */

#ifndef TREEBYTE_H_SENTRY
#define TREEBYTE_H_SENTRY


/* Please note ``levels'' is always measured in bytes of the key;
   actually the tree has exactly 2*levels of the real depths.
 */

struct treebyte {
    struct treebyte_node *root;
    int levels;
};

void treebyte_init(struct treebyte *p, int levels);
void treebyte_clear(struct treebyte *p);

void *treebyte_get(const struct treebyte *p, const void *key);
void **treebyte_provide(struct treebyte *p, const void *key);
int treebyte_delete(struct treebyte *p, const void *key);


struct treebyte_iter;

    /* WARNING! kplen is in HALFbytes!!! UNLIKE those ``levels''.
       This is because we need to implement searching by a prefix
       given as a string of hex digits
     */
struct treebyte_iter *
treebyte_make_iter(struct treebyte *p, const void *keypref, int kplen);

void treebyte_dispose_iter(struct treebyte_iter *p);

    /* Returns the address of the pointer to the object.  The pointer
       itself may be NULL if, e.g., the user called tree_provide but
       didn't modify the pointer returned by its location.  However,
       the NULL address returned (as opposit to an address of a NULL
       pointer) means the iteration process is complete, there are no
       more objects stored in the (sub)tree.
     */
void **treebyte_iter_next(struct treebyte_iter *p);


#endif
