#ifndef POINTCFG_H_SENTRY
#define POINTCFG_H_SENTRY


#include "cryptodf.h"
#include "keyutils.h"
#include "textrec.h"


struct point_config_file {
    unsigned char node_id[node_id_size];
    int point;
    int signed_by;
    int rank;
    int minpref;
    unsigned char master_pub[public_key_size];
    unsigned char master_hash[yespower_hash_size];
    unsigned char master_hsign[signature_size];
    unsigned char zp_certbody[feda_cert_size];
    unsigned char zp_signature[signature_size];
    unsigned char certbody[feda_cert_size];
    unsigned char signature[signature_size];
    unsigned char public_key[public_key_size];
};

enum {
    rcf_res_ok = textrec_res_ok,
    rcf_res_unknown_field = 1,
    rcf_res_incorrect_blob_size = 4,
    rcf_res_cant_open_file = 1000,
    rcf_res_unexpected_thing = 1001
};

int read_config_file(const char *name,
                     struct point_config_file *data, int *errln);

const char *rcf_error_message(int code);



#if 0   /* was implemented once, but shouldn't become needed again */
    /* returns boolean value */
int write_config_file(const char *name, struct config_file *data);
#endif


#endif
