#include <stdio.h>
#include <string.h>

#include "textrec.h"

#include "pointcfg.h"






static int configfile_type_cb(const char *field_name, void *user_data)
{
    if( 0 == strcmp(field_name, "point") ||
        0 == strcmp(field_name, "signed_by") ||
        0 == strcmp(field_name, "rank") ||
        0 == strcmp(field_name, "minpref")
    )
        return ftype_integer;

    if( 0 == strcmp(field_name, "node_id") ||
        0 == strcmp(field_name, "master_pub") ||
        0 == strcmp(field_name, "master_hash") ||
        0 == strcmp(field_name, "master_hsign") ||
        0 == strcmp(field_name, "zp_certbody") ||
        0 == strcmp(field_name, "zp_signature") ||
        0 == strcmp(field_name, "certbody") ||
        0 == strcmp(field_name, "signature") ||
        0 == strcmp(field_name, "public") ||
        0 == strcmp(field_name, "msg_public") ||
        0 == strcmp(field_name, "msgpub_sign")
    )
        return ftype_blob;

    return ftype_ignored;
}

#define BLOB_FIELD_IF(Name, Target)               \
    if(0 == strcmp(fnm, Name)) {                  \
        if(len != sizeof(Target))                 \
            return rcf_res_incorrect_blob_size;   \
        memcpy(Target, buf, len);                 \
        return rcf_res_ok;                        \
    } else

static int
configfile_blob_cb(const char *fnm, const uchar *buf, int len, void *ud)
{
    struct point_config_file *cfr = ud;

    BLOB_FIELD_IF("node_id", cfr->node_id)
    BLOB_FIELD_IF("master_pub", cfr->master_pub)
    BLOB_FIELD_IF("master_hash", cfr->master_hash)
    BLOB_FIELD_IF("master_hsign", cfr->master_hsign)
    BLOB_FIELD_IF("zp_certbody", cfr->zp_certbody)
    BLOB_FIELD_IF("zp_signature", cfr->zp_signature)
    BLOB_FIELD_IF("certbody", cfr->certbody)
    BLOB_FIELD_IF("signature", cfr->signature)
    BLOB_FIELD_IF("public", cfr->public_key)
    {
        return rcf_res_unknown_field;
    }
}

static int configfile_integer_cb(const char *fnm, long long num, void *ud)
{
    struct point_config_file *cfr = ud;

    if(0 == strcmp(fnm, "point")) {
        cfr->point = num;
        return 0;
    } else
    if(0 == strcmp(fnm, "signed_by")) {
        cfr->signed_by = num;
        return 0;
    } else
    if(0 == strcmp(fnm, "rank")) {
        cfr->rank = num;
        return 0;
    } else
    if(0 == strcmp(fnm, "minpref")) {
        cfr->minpref = num;
        return 0;
    } else
    {
        return rcf_res_unknown_field;
    }
}

static int run_parser_on_file(struct textrec_parser *parser, const char *name,
                              int *errline)
{
    FILE *f;
    int c, res;

    f = fopen(name, "r");
    if(!f)
        return rcf_res_cant_open_file;

    while((c = fgetc(f)) != EOF) {
        res = textrec_feedchar(parser, c);
        if(res != textrec_res_ok)
            break;
    }
    if(c == EOF)
        res = textrec_feedchar(parser, EOF);
    fclose(f);

    
    if(res != textrec_res_ok && res != textrec_res_eof) {
        if(errline)
            *errline = parser->line;
        return res;
    }

    return rcf_res_ok;
}

int read_config_file(const char *name,
                     struct point_config_file *data, int *errln)
{
    struct textrec_parser parser;
    int res;

    textrec_init(&parser);

    textrec_set_type_cb(&parser, configfile_type_cb);
    textrec_set_blob_cb(&parser, configfile_blob_cb);
    textrec_set_integer_cb(&parser, configfile_integer_cb);

    textrec_set_user_data(&parser, data);
    memset(data, 0, sizeof(*data));

    res = run_parser_on_file(&parser, name, 0);

    textrec_cleanup(&parser);
    return res;
}

#if 0  /* we should never need this again, but if we do one day,
          don't forget to change the rerurn values (to rcf_res_*) */
int write_config_file(const char *name, struct config_file *data)
{
    FILE *f;
    f = fopen(name, "w");
    if(!f) {
        message_perror(mlv_alert, "FATAL", name);
        return 0;
    }
    put_hex_field(f, "node_id", data->node_id, sizeof(data->node_id));
    put_int_field(f, "point", data->point);
    put_int_field(f, "rank", data->rank);
    put_int_field(f, "minpref", data->minpref);
    put_hex_field(f, "master_pub", data->master_pub, sizeof(data->master_pub));
    put_hex_field(f, "master_hash", data->master_hash,
                                    sizeof(data->master_hash));
    put_hex_field(f, "master_hsign", data->master_hsign,
                                    sizeof(data->master_hsign));
    if(data->point != -1) {
        put_hex_field(f, "public", data->public_key, sizeof(data->public_key));
        put_int_field(f, "signed_by", data->signed_by);
        put_hex_field(f, "certbody", data->certbody, sizeof(data->certbody));
        put_hex_field(f, "signature", data->signature,
                                      sizeof(data->signature));
        if(!all_zeroes(data->zp_certbody, sizeof(data->zp_certbody))) {
            put_hex_field(f, "zp_certbody", data->zp_certbody,
                                            sizeof(data->zp_certbody));
            put_hex_field(f, "zp_signature", data->zp_signature,
                                             sizeof(data->zp_signature));
        }
    }
    fclose(f);
    return 1;
}
#endif



const char *rcf_error_message(int code)
{
    switch(code) {
    case rcf_res_unknown_field:        return "unknown field name";
    case rcf_res_incorrect_blob_size:  return "wrong blob size";
    case rcf_res_cant_open_file:       return "can't open file";
    case rcf_res_unexpected_thing:     return "unexpected situation (bug)";
    default:
        return textrec_error_message(code);
    }
}
