#ifndef NMOBFUSC_H_SENTRY
#define NMOBFUSC_H_SENTRY

/*
    These functions are not intended to be ``strong'' in any sense,
    specially not in the sence of cryptography.  Furthermore, they
    don't use any keys, and their bodies are intended as the
    reference implementation to be included within the FEDAprotocol's
    specification. meaning that they aren't ``secret'' in any way.

    Their intended use is to turn _sequential_ nonces (which in the
    case of FEDAnet are just 64-bit integers, written in the
    little-endian byte order, always starting with smth. like
    0x0100'0000'0000'0000 to 0x01ff'ffff'ffff'ffff for each generated
    symmetric key, incremented by 1 for each sequential use) into
    something which at least looks like random data for a human, or
    for an analyzer unaware of the FEDAprotocol.

    Please note that nonces, by their nature, can not be encrypted.
    On the other hand, generating random nonces for every datagram
    would impose somewhat high load on the random number generator,
    and the nonce itself would have to be several times longer.
 */


void obfuscate_buffer(unsigned char *buf, int size);
void deobfuscate_buffer(unsigned char *buf, int size);

#endif
