#include "nmobfusc.h"


void obfuscate_buffer(unsigned char *buf, int size)
{
    int i;
    *buf ^= 0x5a;
    for(i = 1; i < size; i++) {
        unsigned char pb, mask, cb, sft;

        pb = buf[i-1];
        mask = (pb & 0xf8) | ((pb >> 5) & 0x07); /* xxxyyzzz => xxxyyxxx */
        mask ^= (i & 0x0f) | ((i<<4) & 0xf0);
        sft = (pb & 0x07) ^ (i & 0x07);          /* zzz used for shift */
        cb = buf[i] ^ mask;
        if(sft)
            cb = (cb >> sft) | ((cb << (8-sft)) & (0xff << (8-sft)));
        buf[i] = cb;
    }
}

void deobfuscate_buffer(unsigned char *buf, int size)
{
    int i;
    for(i = size-1; i >= 1; i--) {
        unsigned char pb, mask, cb, sft;

        pb = buf[i-1];
        mask = (pb & 0xf8) | ((pb >> 5) & 0x07);
        mask ^= (i & 0x0f) | ((i<<4) & 0xf0);
        sft = 8 - ((pb & 0x07) ^ (i & 0x07));
        cb = buf[i];
        if(sft)
            cb = (cb >> sft) | ((cb << (8-sft)) & (0xff << (8-sft)));
        buf[i] = cb ^ mask;
    }
    *buf ^= 0x5a;
}




#ifdef NMOBFUSC_TEST

/*
 *  To have the testing binary, compile with:
 *
 *       gcc -Wall -g -D NMOBFUSC_TEST nmobfusc.c hexdata.c
 */

#include <stdio.h>
#include "hexdata.h"

int main()
{
    unsigned long long n;
    int r;
    while((r = scanf("%lld", &n)) == 1) {
        printf("IN:  %s\n", hexdata2a((unsigned char *)&n, sizeof(n)));
        obfuscate_buffer((unsigned char *)&n, sizeof(n));
        printf("OUT: %s\n", hexdata2a((unsigned char *)&n, sizeof(n)));
        deobfuscate_buffer((unsigned char *)&n, sizeof(n));
        printf("RST: %s\t(%lld)\n",
            hexdata2a((unsigned char *)&n, sizeof(n)), n);
    }
    return 0;
}

#endif

#if 0
        printf("* i=%d pb=%02x mask=%02x cb=%02x sft=%02x cb^mask=%02x\n",
               i, pb, mask, cb, sft, cb^mask);
#endif
