#include <string.h>
#include <monocypher/monocypher.h>

#include "cryptodf.h"
#include "xyespwr.h"
#include "fedapref.h"

#include "mastrkey.h"

int check_master_pub(const unsigned char id[],
                     const unsigned char pub[],
                     const unsigned char hash[],
                     const unsigned char hash_sign[],
                     int may_take_hash)
{
    int res;
    unsigned char ghash[yespower_hash_size];

    res = memcmp(id, pub + (public_key_size-node_id_size), node_id_size);
    if(res != 0)
        return checkmasterpub_wrong_id;

    if(may_take_hash) {
        res = take_yespower_hash(ghash, pub);
        if(!res)
            return checkmasterpub_hash_fail;
    
        res = memcmp(hash, ghash, yespower_hash_size);
        if(res != 0)
            return checkmasterpub_wrong_hash;
    }
    if(hash_sign) {
        res = crypto_eddsa_check(hash_sign, pub, hash, yespower_hash_size);
        if(res != 0 /* sic */)
            return checkmasterpub_wrong_hash_sign;
    }

    return feda_prefix_len(hash, yespower_hash_size);
}

const char *checkmasterpub_message(int code)
{
    switch(code) {
    case checkmasterpub_hash_fail:
        return "can't take the yespower hash";
    case checkmasterpub_wrong_id:
        return "declared node ID doesn't match the key";
    case checkmasterpub_wrong_hash:
        return "computed hash doesn't match";
    case checkmasterpub_wrong_hash_sign:
        return "wrong master hash signature";
    default:
        return NULL;
    }
}
