#ifndef KNOWNDB_H_SENTRY
#define KNOWNDB_H_SENTRY

/* It is an important decision that this module never computes the
   yespower hash.  Being used from within fedakeys, it must be supplied
   with the hash computed by the caller; as with fedaserv, there are
   different possibilities on who and when will compute the hash, as it
   is definitely inappropriate to compute it inside the main loop.
 */

enum {
    kndb_res_success           =  0,
        /* -1 is not used, deliberately */
    kndb_res_node_unknown      = -2,
    kndb_res_node_key_differs  = -3,  /* what we know is not what we see */
    kndb_res_wrong_node_key    = -4,  /* master pub doesn't match node id */
    kndb_res_node_rank_low     = -5,
    kndb_res_point_unknown     = -6,
    kndb_res_cert_outdated     = -7,
    kndb_res_zpcert_outdated   = -8,
    kndb_res_signature_fail    = -9,
    kndb_res_file_not_found    = -100,
    kndb_res_file_error        = -101,
    kndb_res_format_error      = -102,
    kndb_res_unexpected_thing  = -103,
    kndb_res_not_implemented   = -104
};

const char *kndb_result_message(int code);

struct known_nodes_db;

struct known_nodes_db *make_kndb(const char *dir, int minprf);
void dispose_kndb(struct known_nodes_db *p);


    /* rank, pubkey, hash, hsign may be NULL if the caller doesn't need 'em */
int kndb_get_node(struct known_nodes_db *p, const unsigned char *node_id,
                  int *rank, unsigned char *pubkey, unsigned char *hash,
                  unsigned char *hsign);

int kndb_save_node(struct known_nodes_db *p, const unsigned char *node_id,
                   const unsigned char *master_pub, int rank,
                   const unsigned char *master_hash,
                   const unsigned char *master_hsign);

int kndb_check_save_node(struct known_nodes_db *kndb,
                         const unsigned char *node_id,
                         const unsigned char *master_pub,
                         const unsigned char *master_hash,
                         const unsigned char *master_hsign,
                         const unsigned char *computed_hash);

int kndb_get_minpref(struct known_nodes_db *p, const unsigned char *node_id,
                     int *minpref);
void kndb_set_minpref(struct known_nodes_db *p, const unsigned char *node_id,
                      int minpref);

    /* possible results: kndb_res_success (we know it, accept it!),
       kndb_res_node_unknown (we don't know that node, won't take hash)
       ans kndb_res_node_key_differs (node's known, master_pub differs)
     */
int kndb_consider_node(struct known_nodes_db *p,
                       const unsigned char *node_id,
                       const unsigned char *node_master_pub);

    /* timestamp may be NULL */
int kndb_get_point_pubkey(struct known_nodes_db *p,
                          const unsigned char *node_id, int point,
                          unsigned char *pubkey, int *timestamp);

int kndb_save_point(struct known_nodes_db *p,
                    const struct feda_cert_info *cert,
                    const unsigned char *signature);

    /* determine whether we can accept the cert immediately, without
       taking the master hash, even if it is allowed; we only compute
       yespower hashes after the peer explicitly asked us to do, after
       it solves challenges we give, so DDoS can't be caused; but that's
       done via a completely different interface

       point signatures may still be computed, it's not a problem, they
       are fast enough
     */ 
int kndb_did_we_know(struct known_nodes_db *p,
                     const unsigned char *node_id, int point,
                     const unsigned char *zp_certbody,
                     const unsigned char *zp_signature,
                     const unsigned char *point_certbody,
                     const unsigned char *point_signature,
                     unsigned char *pubkey);

#endif
