#include "cryptodf.h"
#include "keyutils.h"  /* for cert sizes */
#include "kfschems.h"

#define MDT ftypex_mandatory 

struct textrecx_field_descriptor schema_nodecert_public[] = {
    { ftype_blob   |MDT, "node_id",       node_id_size       },
    { ftype_integer|MDT, "rank"                              },
    { ftype_integer|MDT, "minpref"                           },
    { ftype_blob   |MDT, "master_pub",    public_key_size    },
    { ftype_blob   |MDT, "master_hash",   yespower_hash_size },
    { ftype_blob   |MDT, "master_hsign",  signature_size     },
    { ftype_unknown, "" }
};

struct textrecx_field_descriptor schema_point_public[] = {
    { ftype_blob   |MDT, "node_id",       node_id_size       },
    { ftype_integer|MDT, "point"                             },
    { ftype_integer|MDT, "rank"                              },
    { ftype_integer|MDT, "minpref"                           },
    { ftype_integer|MDT, "signed_by"                         },
    { ftype_blob   |MDT, "master_pub",    public_key_size    },
    { ftype_blob   |MDT, "master_hash",   yespower_hash_size },
    { ftype_blob   |MDT, "master_hsign",  signature_size     },
    { ftype_blob,        "zp_certbody",   feda_cert_size     },
    { ftype_blob,        "zp_signature",  signature_size     },
    { ftype_blob   |MDT, "certbody",      feda_cert_size     },
    { ftype_integer|MDT, "timestamp"                         },
    { ftype_blob   |MDT, "signature",     signature_size     },
    { ftype_blob   |MDT, "public",        public_key_size    },
    { ftype_blob,        "kex_public",    kex_public_size    },
    { ftype_blob,        "kex_cert",      feda_kex_info_size },
    { ftype_blob,        "kex_signature", signature_size     },
    { ftype_integer,     "kex_timestamp"                     },
    { ftype_unknown, "" }
};

struct textrecx_field_descriptor schema_known_node[] = {
    { ftype_blob   |MDT, "node_id",       node_id_size       },
    { ftype_integer|MDT, "rank"                              },
    { ftype_blob   |MDT, "master_pub",    public_key_size    },
    { ftype_blob   |MDT, "master_hash",   yespower_hash_size },
    { ftype_blob   |MDT, "master_hsign",  signature_size     },
    { ftype_unknown, "" }
};

struct textrecx_field_descriptor schema_known_node_info[] = {
    { ftype_unknown, " " },    /* tolerate unknown fields */
    { ftype_integer|MDT, "minpref"                           },
    { ftype_unknown, "" }
};

struct textrecx_field_descriptor schema_known_point[] = {
    { ftype_blob   |MDT, "node_id",       node_id_size       },
    { ftype_integer|MDT, "point"                             },
    { ftype_integer|MDT, "timestamp"                         },
    { ftype_integer|MDT, "signed_by"                         },
    { ftype_blob   |MDT, "public",        public_key_size    },
    { ftype_blob   |MDT, "certbody",      feda_cert_size     },
    { ftype_blob   |MDT, "signature",     signature_size     },
    { ftype_unknown, "" }
};

struct textrecx_field_descriptor schema_known_point_kex[] = {
    { ftype_blob   |MDT, "kex_public",    kex_public_size    },
    { ftype_blob   |MDT, "kex_cert",      feda_kex_info_size },
    { ftype_blob   |MDT, "kex_signature", signature_size     },
    { ftype_integer|MDT, "kex_timestamp"                     },
    { ftype_integer|MDT, "ptk_timestamp"                     },
    { ftype_unknown, "" }
};

struct textrecx_field_descriptor schema_signature_file[] = {
    { ftype_ignored,     "filename"                          },
    { ftype_blob   |MDT, "signer_node",   node_id_size       },
    { ftype_integer|MDT, "signer_point"                      },
    { ftype_blob   |MDT, "master_pub",    public_key_size    },
    { ftype_blob   |MDT, "master_hash",   yespower_hash_size },
    { ftype_blob   |MDT, "master_hsign",  signature_size     },
    { ftype_blob,        "zp_cert",       feda_cert_size     },
    { ftype_blob,        "zp_certsig",    signature_size     },
    { ftype_blob   |MDT, "point_cert",    feda_cert_size     },
    { ftype_blob   |MDT, "point_certsig", signature_size     },
    { ftype_blob   |MDT, "hash",          68 /* yes I know */},
    { ftype_integer|MDT, "timestamp"                         },
    { ftype_blob   |MDT, "signature",     signature_size     }
};
