#ifndef KFILES_H_SENTRY
#define KFILES_H_SENTRY

#include "textrecx.h"

enum { fieldname_width = 14 };

/* ==== file names ====================================== */

char *make_masterkey_fname(const char *wdir);
char *make_secretkey_fname(const char *wdir);
char *make_zeropointkey_fname(const char *wdir);
char *make_config_fname(const char *wdir);
char *make_msgkey_fname(const char *wdir, const char *key_id);
        /* no more than 10 first chars are used from the key_id string */

void dispose_fname(char *p);

struct kc_path_set {
    char *node_dir;
    char *node_file;
    char *info_file;
    char *zero_point_file;
    char *point_file;
    char *point_kex_file;
};

void make_path_set(const char *wdir, const unsigned char node_id[], int point,
                   struct kc_path_set *s);

char *make_old_point_fname(const char *fname, int timestamp);

void dispose_path_set(struct kc_path_set *s);


/* ==== reading textrec-based files ====================== */

enum {
#if 0
    kfiles_res_eof = textrecx_res_eof,
#endif
    kfiles_res_ok = textrecx_res_ok,
    kfiles_res_file_not_found = 1000,
    kfiles_res_cant_open_file = 1001,
    kfiles_res_unexpected_thing = 1002
};

const char *kfiles_ctx_error_message(int code);


int read_textrecx_file(const char *filename,
                       const struct textrecx_field_descriptor *schema,
                       struct textrecx_data_item **data,
                       int *errline);

int read_single_blob(const char *filename, const char *blobname,
                     unsigned char *buf, int buflen, int *errline);



/* ==== output ========================================== */

int putchar_cb_fputc(int c, void *fstream);

int write_textrecx_file(const char *fname, struct textrecx_data_item *data);


#endif
