#ifndef KEYUTILS_H_SENTRY
#define KEYUTILS_H_SENTRY


#include "cryptodf.h"

    /* returns boolean value */
int get_random(void *buf, int len);

    /* returns boolean value */
int all_zeroes(const unsigned char *buf, int len);

void place_timemark(int tm, unsigned char p[4]);

void increment_buf(unsigned char *buf, int len);


/* --- non-cryptographic randomness (quick pseudorandom numbers) --- */

void fill_noise(unsigned char *buf, int len);

int rand_from_range(int first, int last);


/* --- certificates                                              --- */

struct feda_cert_info { /* all numbers are to be stored big-endian */
    unsigned char feda[4];      /* magic number 0xFEDACE87 */
    unsigned char node_id[node_id_size];
    unsigned char point_id;
    unsigned char signer_id;    /* 0xFF if signed by the node's master key,
                                   0x00 if signed by the PointZero's key   */
    unsigned char timestamp[4]; /* minutes since epoch, a.k.a. unixtime/60 */
    unsigned char key[public_key_size]; /* the key being certified */
};

struct feda_kex_info {
    unsigned char timestamp[4];                /* minutes since epoch */
    unsigned char kex_public[kex_public_size]; /* the kex key being certfd */
};

enum {
    feda_cert_size      = sizeof(struct feda_cert_info),  /* 52 */
    feda_kex_info_size  = sizeof(struct feda_kex_info)    /* 36 */
};

extern const unsigned char fedacert_magic[4];

void compose_feda_cert(struct feda_cert_info *cert,
    const unsigned char node_id[], int point_id, int signer_id, int timestamp,
    const unsigned char key[]);
int get_cert_timestamp(const struct feda_cert_info *cert);

const unsigned char *get_cert_pubkey(const unsigned char *cert);

    /* returns boolean; timestamp==-1 means no timestamp check
                        key==NULL means no pubkey check
     */
int compare_feda_cert(const struct feda_cert_info *cert,
    const unsigned char node_id[], int point_id, int signer_id, int timestamp,
    const unsigned char *key);

void compose_kex_info(struct feda_kex_info *kexinfo,
                      int timestamp, const unsigned char kex_pub[]);

int compare_kex_info(const struct feda_kex_info *kexinfo,
                     int timestamp, const unsigned char kex_pub[]);



#endif
