#ifndef IP6STRUC_H_SENTRY
#define IP6STRUC_H_SENTRY

struct ipv6_data {
    unsigned short pi_flags;
    unsigned short pi_proto;

    unsigned char version;
    unsigned char traffic_class;
    unsigned char next_header;
    unsigned char hop_limit;
    unsigned int flow_label;
    unsigned short payload_length;
    
    const unsigned char *source_addr;
    const unsigned char *dest_addr;
    const unsigned char *payload;
    int payload_size;
};


int parse_ipv6_packet(struct ipv6_data *data, const void *p, int sz, int pi);

enum {
    parse6_ok              = 0,

    parse6_too_short       = 0x0001,   /* sz shorter than the header */
    parse6_buf_small       = 0x0002,   /* PI flags indicate short buf */
    parse6_inv_flags       = 0x0004,   /* PI flags contain smth. strange */
    parse6_pi_ipv4         = 0x0008,   /* PI proto indicates it's IPv4 */
    parse6_pi_unknown_prot = 0x0010,   /* PI proto contains smth. strange */
    parse6_vers_ipv4       = 0x0020,   /* hdr version field is 4 */
    parse6_vers_unknown    = 0x0040,   /* hdr version field not 4 nor 6 */
    parse6_inv_payload_len = 0x0080,   /* hdr payld len mismatches sz */
    parse6_nexth_unknown   = 0x0100,   /* hdr next_hdr value unknown */
    parse6_nexth_cant      = 0x0200,   /* next_hdr present, and it may be
                                          ok, but we don't know how to */

    parse6_no_info         = 0x8000,   /* don't use the data structure as
                                          we didn't fill it */
};

const char * const *parse6_get_diags(int code);

    /* p must point to the packet WITHOUT that damn "packet info";
       the function returns a boolean -- may we still forward the packet */
int ipv6_decrement_hop_limit(void *p);

#endif
