#ifndef HEXDATA_H_SENTRY
#define HEXDATA_H_SENTRY

/* to hex */

char hexdigit(unsigned int n);
void hexbyte2str(char str[3], int bt);
void hexdata2str(char *str, const unsigned char *data, int datalen);

    /* returns internal static buffer, 4096 bytes in size; if the
       buffer's length is insufficient, the hex data is truncated
       accordingly (to 4095 chars, which is odd, heh)
     */
const char *hexdata2a(const unsigned char *data, int datalen);

/* from hex */

int hexdigval(char dig);

    /* returns: > 0 -- count of bytes, success
                = 0 -- none converted
                < 0 -- illegal char position in the string
 
       returning value greater than datasize means all the buffer
       pointed by data is filled, but it's insufficient, while
       the value indicates what would suffice; certainly, the
       function never writes more that datasize to the buffer
     */
int hexstr2data(unsigned char *data, int datasize, const char *str);



/* base32 from hex */

    /* returns 0 on success, or the invalid position within the id,
       starting with 1, if a char in that position is not a hex digit;
       bytes means the count of bytes; the hex string is supposed to be
       two times longer; the value of bytes should be divisible by 5;
       the base32 buffer must be at least (bytes * 8 / 5 + 1) bytes long.
     */
int id_to_base32(char base32[], const char *hex, int bytes);


    /* does not depend on the parameter's alignment in memory,
       works with each of the chars separately
     */
unsigned int u32_from_big_endian(unsigned char d[4]);


#endif
