#include "hexdata.h"

char hexdigit(unsigned int n)
{
    if(n <= 9)
        return n + '0';
    if(n <= 15)
        return n - 10 + 'a';
    return '?'; /* should never happen */
}

void hexbyte2str(char str[3], int bt)
{
    str[0] = hexdigit((bt >> 4) & 0x0f);
    str[1] = hexdigit(bt        & 0x0f);
    str[2] = 0;
}

void hexdata2str(char *str, const unsigned char *data, int datalen)
{
    int i;
    char *p = str;
    for(i = 0; i < datalen; i++) {
        hexbyte2str(p, data[i]);
        p += 2;
    }
    /* *p = 0; -- no longer needed, done by hexbyte2str */
}

const char *hexdata2a(const unsigned char *data, int datalen)
{
    static char buf[4096];
    if(datalen * 2 + 1 > sizeof(buf))
        datalen = (sizeof(buf) - 1) / 2;
    hexdata2str(buf, data, datalen);
    return buf;
}

int hexdigval(char dig)
{
    if(dig >= '0' && dig <= '9')
        return dig - '0';
    if(dig >= 'a' && dig <= 'f')
        return dig - 'a' + 10;
    if(dig >= 'A' && dig <= 'F')
        return dig - 'A' + 10;
    return -1;
}

static int iswhitespace(int c)
{
    return c == ' ' || c == '\t' || c == '\r' || c == '\n';
}

    /* returns: > 0 -- count of bytes, success
                = 0 -- none converted
                < 0 -- illegal char position in the string, starting with 1
     */
int hexstr2data(unsigned char *data, int datasize, const char *str)
{
    int dest, i, half, val;
    dest = 0;
    half = 0;
    for(i = 0; str[i]; i++) {
        char c = str[i];
        int dig;
        if(iswhitespace(c))
            continue;
        dig = hexdigval(c);
        if(dig == -1)
            return -(i+1);
        val = !half ? ((dig << 4) & 0xf0) : (val | (dig & 0x0f));
        if(half) {
            if(dest < datasize)
                data[dest] = val;
            dest++;
        }
        half = !half;
    }
    return half ? -(i+1) : dest;
}



/* ----------------- base32 ------------------- */

static int base32digit(unsigned int v)
{
    return "abcdefghijklmnopqrstuvwxyz234567"[v & 0x1f];
}

int id_to_base32(char base32[], const char *id, int bytes)
{
    int i;
    int cur;
    int bits;
    char *p;

    p = base32;
    cur = 0;
    bits = 0;
    for(i = 0; i < bytes * 2 && id[i]; i++) {
        int dv = hexdigval(id[i]);
        if(dv == -1)
            return i + 1;
        bits += 4;
        cur <<= 4;
        cur |= (dv & 0x0f);
        if(bits >= 5) {
            int v = (bits == 5 ? cur : cur >> (bits - 5)) & 0x1f;
            bits -= 5;
            *p = base32digit(v);
            p++;
        }
    }
    *p = 0;
    return 0;
}

unsigned int u32_from_big_endian(unsigned char d[4])
{
    return
        ((unsigned int)d[0] << 24) |
        ((unsigned int)d[1] << 16) |
        ((unsigned int)d[2] <<  8) |
        ((unsigned int)d[3]);
}
