#ifndef FSRV_TXQ_H_SENTRY
#define FSRV_TXQ_H_SENTRY


/* The min_retry_time value is presently hardcoded as 10 seconds; this
   might change one day.

   What min_retry_time actually means is the minimal time to pass before an
   unanswered datagram is resent again.
 */
enum { min_retry_time = 10 };

enum { feda_txq_default_retries = 3 };

struct sue_event_selector;
struct sue_timeout_handler;

struct feda_udp_receiver;
struct feda_peer;

struct feda_transmit_queue;

struct feda_transmit_queue *make_transmit_queue(struct sue_event_selector *s);

int feda_txq_want_write(const struct feda_transmit_queue *txq);

struct feda_transmit_item {
    struct feda_transmit_queue *master;
    unsigned char *buf;
    int len, offset;    /* len is of the buf, message is (len-offset) long */
    unsigned int ip;
    unsigned short port;
    char direct;
    char retries;
    struct sue_timeout_handler *tmh;
    unsigned long cookie;
    struct feda_peer *the_peer;
    struct feda_transmit_item *next;
};

struct feda_transmit_item *make_txitem_4peer(struct feda_transmit_queue *txq,
                            int len, int offset, struct feda_peer *the_peer); 

struct feda_transmit_item *make_txitem_4ip(struct feda_transmit_queue *txq,
                  int len, int offset, unsigned int ip, unsigned short port); 

void
txitem_set_retry(struct feda_transmit_item *item, unsigned long cookie);

void feda_txq_got_cookie(struct feda_transmit_queue *txq, unsigned long cook);

void feda_txq_peer_gone(struct feda_transmit_queue *txq, struct feda_peer *fp);

    /* ownership for item and item->buf transferred here */
void feda_txq_enqueue(struct feda_transmit_item *item);

#if 0
void feda_txq_process_send(struct feda_transmit_queue *txq, int fd);
#endif

struct feda_transmit_item *
fetch_item_to_transmit(struct feda_transmit_queue *txq);

void feda_txitem_sent(struct feda_transmit_item *p);



#endif
