#include <stdlib.h>
#include <sys/types.h>
#if 0
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif
#include <time.h>

#include <sue/sue_base.h>

#include "hexdata.h"
#include "addrport.h"
#include "servlog.h"
#include "fsrv_pir.h"

#include "fsrv_txq.h"


struct feda_transmit_queue {
    struct sue_event_selector *the_selector;
    long long starttime;
    long curtime;
    struct feda_transmit_item *qfirst, *qlast;
    struct feda_transmit_item *retx_first, *retx_last;
};

struct feda_transmit_queue *make_transmit_queue(struct sue_event_selector *s)
{
    struct feda_transmit_queue *res;

    res = malloc(sizeof(*res));
    res->the_selector = s;
    res->starttime = time(NULL);
    res->curtime = 0;
    res->qfirst = NULL;
    res->qlast = NULL;
    res->retx_first = NULL;
    res->retx_last = NULL;

    return res;
}

#if 0
struct feda_transmit_item {
    unsigned char *buf;
    int len, offset;    /* len is of the buf, message is (len-offset) long */
    unsigned int ip;
    unsigned short port;
    char retries;
    long next_retry;
    unsigned long cookie;
    struct feda_peer *the_peer;
    struct feda_transmit_item *next;
};
#endif


static struct feda_transmit_item *make_txitem(struct feda_transmit_queue *txq,
                                              int len, int offset)
{
    struct feda_transmit_item *res;
    res = malloc(sizeof(*res));
    res->master = txq;
    res->buf = malloc(len);
    res->len = len;
    res->offset = offset;
    res->direct = 0;
    res->retries = -1;
    res->tmh = NULL;
    res->cookie = 0;
    res->the_peer = NULL;
    res->next = NULL;
    return res;
}

static void destroy_txitem(struct feda_transmit_item *p)
{
    if(p->tmh) {   /* this means it is registered on the selector */
        sue_sel_remove_timeout(p->master->the_selector, p->tmh);
        free(p->tmh);
    }
    free(p->buf);
    free(p);
}

struct feda_transmit_item *make_txitem_4peer(struct feda_transmit_queue *txq,
                                    int len, int offset, struct feda_peer *fp)
{
    struct feda_transmit_item *res;
    res = make_txitem(txq, len, offset);
    feda_peer_getaddr(fp, &res->ip, &res->port);
    res->the_peer = fp;
    res->direct = feda_peer_is_direct(fp);
    return res;
}

struct feda_transmit_item *make_txitem_4ip(struct feda_transmit_queue *txq,
                   int len, int offset, unsigned int ip, unsigned short port)
{
    struct feda_transmit_item *res;
    res = make_txitem(txq, len, offset);
    res->ip = ip;
    res->port = port;
    res->the_peer = NULL;
    return res;
}

void feda_txq_got_cookie(struct feda_transmit_queue *txq, unsigned long cookie)
{
    struct feda_transmit_item *tmp;
    struct feda_transmit_item **pp;

    pp = &txq->retx_first;
    while(*pp) {
        if((*pp)->cookie == cookie) {
            tmp = *pp;
            *pp = (*pp)->next;
            tmp->next = NULL;
            destroy_txitem(tmp);
            return;
        }
        pp = &(*pp)->next;
    }
}

void feda_txq_peer_gone(struct feda_transmit_queue *txq, struct feda_peer *fp)
{
    struct feda_transmit_item *tmp;
    struct feda_transmit_item **pp;

    for(tmp = txq->qfirst; tmp; tmp = tmp->next)
        if(tmp->the_peer == fp)
            tmp->the_peer = NULL;

    pp = &txq->retx_first;
    while(*pp) {
        if((*pp)->the_peer == fp) {
            tmp = *pp;
            *pp = (*pp)->next;
            tmp->next = NULL;
            destroy_txitem(tmp);
        } else {
            pp = &(*pp)->next;
        }
    }
}


    /* ownership for item and item->buf transferred here */
void feda_txq_enqueue(struct feda_transmit_item *item)
{
    struct feda_transmit_queue *txq = item->master;
    if(txq->qlast)
        txq->qlast->next = item;
    else
        txq->qfirst = item;
    txq->qlast = item;
    item->next = NULL;
    if(item->the_peer) {
        feda_peer_inc_unsent(item->the_peer);
        update_peer_last_tx(item->the_peer);
    }
}

int feda_txq_want_write(const struct feda_transmit_queue *txq)
{
    return txq->qfirst != NULL;
}

void txitem_set_retry(struct feda_transmit_item *item, unsigned long cookie)
{
    item->retries = feda_txq_default_retries;
    item->cookie = cookie;
}


static void feda_txq_handle_timeout(struct sue_timeout_handler *tmh)
{
    struct feda_transmit_item *item = tmh->userdata;

    /* must be item->tmh == tmh... well, we don't check */

    free(tmh);
    item->tmh = NULL;
    item->retries--;
    servlog_message(srvl_debug, "to retransmit: cookie %08x (%d left)",
                    item->cookie, item->retries);
    feda_txq_enqueue(item);
}


static void add_for_resending(struct feda_transmit_queue *txq,
                              struct feda_transmit_item *item)
{
    item->next = NULL;
    if(txq->retx_last)
        txq->retx_last->next = item;
    else
        txq->retx_first = item;
    txq->retx_last = item;

    if(item->tmh) {  /* must not happen! */
        servlog_message(srvl_alert,
            "msg being added for resending already has timeout handler!");
        sue_sel_remove_timeout(txq->the_selector, item->tmh);
        free(item->tmh);
    }
    item->tmh = malloc(sizeof(*item->tmh));
    item->tmh->userdata = item;
    item->tmh->handle_timeout = &feda_txq_handle_timeout;
    sue_timeout_set_from_now(item->tmh, min_retry_time, 0);
    sue_sel_register_timeout(txq->the_selector, item->tmh);
}


#if 0
void feda_txq_process_send(struct feda_transmit_queue *txq, int fd)
{
    struct feda_transmit_item *tmp;
    struct sockaddr_in saddr;
    int r, mlen;

    tmp = txq->qfirst;
    if(!tmp) {
        servlog_message(srvl_alert, "ready to send, but nothing to send");
        return;
    }
    txq->qfirst = tmp->next;
    if(!txq->qfirst)
        txq->qlast = NULL;

    saddr.sin_family = AF_INET;
    saddr.sin_addr.s_addr = htonl(tmp->ip);
    saddr.sin_port = htons(tmp->port);

    mlen = tmp->len - tmp->offset;
    r = sendto(fd, tmp->buf + tmp->offset, mlen,
               0, (struct sockaddr*)&saddr, sizeof(saddr));
    if(r < 1) {
        servlog_perror(srvl_alert, "ALERT", "sendto");
        servlog_message(srvl_alert, "error sending %d bytes to %s",
                                    mlen, ipport2a(tmp->ip, tmp->port));
    }
    if(r != mlen) {
        servlog_message(srvl_alert,
                        "dgram len mismatch: %d to send, %d sent", mlen, r);
    }

    if(tmp->the_peer)
        feda_peer_dec_unsent(tmp->the_peer);
    servlog_message(srvl_debug2, "sent %d bytes to %s [%s...]; %d%s",
                    r, ipport2a(tmp->ip, tmp->port),
                    hexdata2a(tmp->buf + tmp->offset, 5),
                    tmp->the_peer ? feda_peer_get_unsent(tmp->the_peer) : 0,
                    tmp->the_peer ? " unsent for the peer" : "");

    if(tmp->retries > 0)
        add_for_resending(txq, tmp);
    else
        destroy_txitem(tmp);
}
#endif


struct feda_transmit_item *
fetch_item_to_transmit(struct feda_transmit_queue *txq)
{
    struct feda_transmit_item *tmp;
    int mlen;

    tmp = txq->qfirst;
    if(!tmp) {
        servlog_message(srvl_alert, "ready to send, but nothing to send");
        return NULL;
    }
    txq->qfirst = tmp->next;
    if(!txq->qfirst)
        txq->qlast = NULL;

    if(tmp->the_peer)
        feda_peer_dec_unsent(tmp->the_peer);
    mlen = tmp->len - tmp->offset;
    servlog_message(srvl_debug2, "going to send %d bytes to %s [%s...]; %d%s",
                    mlen, ipport2a(tmp->ip, tmp->port),
                    hexdata2a(tmp->buf + tmp->offset, 5),
                    tmp->the_peer ? feda_peer_get_unsent(tmp->the_peer) : 0,
                    tmp->the_peer ? " unsent for the peer" : "");
    return tmp;
}

void feda_txitem_sent(struct feda_transmit_item *p)
{
    if(p->master && p->retries > 0)
        add_for_resending(p->master, p);
    else
        destroy_txitem(p);
}
