#ifndef FSRV_TUN_H_SENTRY
#define FSRV_TUN_H_SENTRY

/*
   This module handles the tunX (well, typically feda0) virtual network
   device.  It establishes a SUE reader to read from the interface, and
   dispatches received packets to their respective destinations.  It also
   allows to push a packet to the local system using the interface.
 */

struct sue_event_selector;
struct feda_udp_receiver;
struct feda_destination_map;

struct feda_tunnel_gate;

struct feda_tunnel_gate *make_tunnel_gate(struct sue_event_selector *s,
                                          struct feda_udp_receiver *feda_rx,
                                          struct feda_destination_map *dm,
                                          const char *iface_name);

void push_packet_locally(struct feda_tunnel_gate *tun,
                         const unsigned char *buf, int size);

#endif
