#include <stdlib.h>
#include <signal.h>

#include <sue/sue_base.h>

#include "fsrv_rx.h"

#include "fsrv_sig.h"

struct feda_signal_target {
    struct sue_signal_handler sigusr1h;
    struct sue_signal_handler siginth;
    struct sue_signal_handler sigquith;
    struct sue_signal_handler sigtermh;
    struct feda_udp_receiver *the_feda_rx;
    struct sue_event_selector *the_selector;
};


/* please note that 'handlers' are called from within the main loop,
   NOT from within the actual signal handler, so it is safe to use
   whatever functions, calls etc. in these functions
 */

static void sigusr1_hdl(struct sue_signal_handler *h, int cnt)
{
    struct feda_signal_target *st = h->userdata;
    feda_udp_receiver_report(st->the_feda_rx);
}

static void quit_on_sig(struct sue_signal_handler *h, int cnt)
{
    struct feda_signal_target *st = h->userdata;
    sue_sel_break(st->the_selector); 
}

struct feda_signal_target *make_signal_target(struct sue_event_selector *sel,
                                           struct feda_udp_receiver *feda_rx)
{
    struct feda_signal_target *p;
    p = malloc(sizeof(*p));

    p->sigusr1h.signo = SIGUSR1;
    p->sigusr1h.userdata = p;
    p->sigusr1h.handle_signal = sigusr1_hdl;

    p->siginth.signo = SIGINT;
    p->siginth.userdata = p;
    p->siginth.handle_signal = quit_on_sig;

    p->sigquith.signo = SIGQUIT;
    p->sigquith.userdata = p;
    p->sigquith.handle_signal = quit_on_sig;

    p->sigtermh.signo = SIGTERM;
    p->sigtermh.userdata = p;
    p->sigtermh.handle_signal = quit_on_sig;

    p->the_feda_rx = feda_rx;
    p->the_selector = sel;

    sue_sel_register_signal(sel, &p->sigusr1h);
    sue_sel_register_signal(sel, &p->siginth);
    sue_sel_register_signal(sel, &p->sigquith);
    sue_sel_register_signal(sel, &p->sigtermh);

    return p;
}
