#ifndef FSRV_RX_H_SENTRY
#define FSRV_RX_H_SENTRY


struct sue_event_selector;
struct server_conf_info;
struct point_config_file;
struct feda_tunnel_gate;
struct feda_destination_map;
struct feda_pir_collection;
struct feda_peer;
struct feda_proxy_set;

struct feda_udp_receiver;

struct feda_udp_receiver *
make_udp_receiver(struct sue_event_selector *s, struct server_conf_info *cfg);

int launch_udp_receiver(struct feda_udp_receiver *feda_rx);

void udp_receiver_set_tun(struct feda_udp_receiver *feda_rx,
                          struct feda_tunnel_gate *tun,
                          struct feda_destination_map *destmap);

void udp_receiver_set_pxyset(struct feda_udp_receiver *feda_rx,
                             struct feda_proxy_set *pxyset);

void feda_rx_set_proxy_peer(struct feda_udp_receiver *feda_rx,
                            struct feda_peer *fp);
void feda_rx_set_nodenets_peer(struct feda_udp_receiver *feda_rx,
                               struct feda_peer *peer);
void feda_rx_peer_gone(struct feda_udp_receiver *feda_rx,
                       struct feda_peer *peer);

    /* just calls sendto and logs the results; used by proxies as well,
       therefore made public
     */
void perform_send_to(int fd, unsigned int ip, unsigned short port,
                     const void *buf, int len);

void send_packet_to_peer(struct feda_udp_receiver *feda_rx,
                         struct feda_peer *peer, unsigned int packid,
                         const unsigned char *buf, int size);
 
    /* called by the pir module only */
void handle_association_process(struct feda_udp_receiver *feda_rx,
                                struct feda_peer *fp);

    /* called by the proxy module only.
       offset must be no less than 7 (msg type 1 + ip 4 + port 2)
       the real size of the buffer is offset + len (or more)
     */
void
handle_proxy_inbound_packet(struct feda_udp_receiver *feda_rx,
                            struct feda_peer *fp_for,
                            unsigned int from_ip, unsigned short from_port,
                            unsigned char *buf, int offset, int len);

    /* called upon the SIGUSR1 */
void feda_udp_receiver_report(struct feda_udp_receiver *feda_rx);

    /* stream is actually FILE*, we just don't want stdio.h in this header */
void feda_udp_receiver_streamrep(struct feda_udp_receiver *feda_rx,
                                 void *stream);

const struct point_config_file *
feda_rx_get_point_cfg(struct feda_udp_receiver *feda_rx);

struct feda_pir_collection *feda_rx_get_pir(struct feda_udp_receiver *feda_rx);

struct feda_destination_map *
feda_rx_get_destmap(struct feda_udp_receiver *feda_rx);


#endif
