#include <stdio.h>
#include <stdarg.h>

#include "servlog.h"

#include "fsrv_rep.h"

void report_to_log_cb(void *ud, const char *fmt, ...)
{
    va_list args;
    va_start(args, fmt);
    servlog_message_vl(*(int*)ud, fmt, args);
    va_end(args);
}

void report_to_stream_cb(void *ud, const char *fmt, ...)
{
    va_list args;
    va_start(args, fmt);
    vfprintf((FILE*)ud, fmt, args);
    fputc('\n', (FILE*)ud);
    va_end(args);
}
