#ifndef FSRV_PXY_H_SENTRY
#define FSRV_PXY_H_SENTRY

#include "fsrv_rep.h"

struct sue_event_selector;
struct feda_udp_receiver;
struct feda_peer;
struct server_conf_info;
struct peer_conf;

struct feda_proxy;
struct feda_proxy_set;


    /* returns NULL if no proxy users are configured */
struct feda_proxy_set *make_proxy_set(struct sue_event_selector *sel,
                                      struct feda_udp_receiver *feda_rx,
                                      struct server_conf_info *conf);

void feda_proxy_peer_gone(struct feda_proxy *pxy);

struct feda_proxy *find_feda_proxy_by_conf(const struct feda_proxy_set *ps,
                                           const struct peer_conf *cfg1,
                                           const struct peer_conf *cfg2);

void feda_proxy_set_peer(struct feda_proxy *pxy, struct feda_peer *fp);


void feda_proxy_send_outbound(struct feda_proxy *pxy,
                              unsigned int ip, unsigned short port,
                              const unsigned char *data, int len);

void feda_proxy_set_report(struct feda_proxy_set *ps,
                           report_callback f, void *userdata);

#endif
