#ifndef FSRV_PIR_H_SENTRY
#define FSRV_PIR_H_SENTRY

/*
   This module implements the peer collection, which means the information
   which ip:port pairs have any 'status' for us.

   If you dislike the idea of reading 'pir' as 'peer', well, assume it is
   something like Peer Information Register.
 */


#include "fsrv_rep.h"

struct feda_udp_receiver;
struct server_conf_info;
struct feda_proxy_set;
struct crypto_comm_context;

struct feda_pir_collection;
struct feda_peer;

struct feda_pir_collection *make_pir_collection(struct feda_udp_receiver *rx,
            struct server_conf_info *cf, struct crypto_comm_context *comctx);
                          
void feda_pir_set_pxyset(struct feda_pir_collection *pir,
                         struct feda_proxy_set *pxyset);

void feda_pir_timer_hook(struct feda_pir_collection *pir);

void feda_pir_report(struct feda_pir_collection *pir,
                     report_callback f, void *userdata);


int feda_peer_set_identity(struct feda_peer *fp,
                           const unsigned char *node_id, int point,
                           const unsigned char *pubkey);

int peer_set_kex_public(struct feda_pir_collection *pir, struct feda_peer *fp,
                        const unsigned char *kex_public, int signchecked);

void update_peer_last_rx(struct feda_peer *fp);
void update_peer_last_tx(struct feda_peer *fp);

int feda_peer_get_point(const struct feda_peer *fp,
                        unsigned char *node_id, int *point);

int feda_peer_inc_unsent(struct feda_peer *fp);
int feda_peer_dec_unsent(struct feda_peer *fp);
int feda_peer_get_unsent(const struct feda_peer *fp);

int feda_peer_inc_stubcred(struct feda_peer *fp);
int feda_peer_dec_stubcred(struct feda_peer *fp);
int feda_peer_stub_credit(const struct feda_peer *fp);
void feda_peer_getaddr(const struct feda_peer *fp,
                       unsigned int *ip, unsigned short *port);

const unsigned char *feda_peer_encrypt_key(const struct feda_peer *fp);
const unsigned char *feda_peer_decrypt_key(const struct feda_peer *fp);
const unsigned char *feda_peer_remote_public(const struct feda_peer *fp);
const unsigned char *feda_peer_remote_kex_pub(const struct feda_peer *fp);

struct feda_peer *get_peer_rec(struct feda_pir_collection *pir,
                               unsigned int ip, unsigned short port, int add);
void set_to_cooldown(struct feda_pir_collection *pir,
                     unsigned long ip, unsigned short port);
int is_cooldown(struct feda_pir_collection *pir,
                unsigned long ip, unsigned short port);
int timemark_minutes(const struct feda_pir_collection *pir);

int feda_peer_is_direct(const struct feda_peer *fp);

void feda_peer_get_idle(const struct feda_peer *fp,
                        int *since_last_rx, int *since_last_tx);

unsigned int feda_peer_get_sequential(struct feda_peer *fp);

enum feda_peer_assoc_status {
    fpas_not_desired,
    fpas_gave_up,
    fpas_none,
    fpas_echo_request_sent,
    fpas_intro_requested,
    fpas_assoc_request_sent,
    fpas_established
};

int feda_peer_should_initiate_assoc(const struct feda_peer *fp);
int feda_peer_assoc_status(const struct feda_peer *fp);
    /* returns the previous status */
int feda_peer_set_assocstatus(struct feda_peer *fp, int newstat);

int feda_peer_ever_had_assoc(const struct feda_peer *fp);

struct feda_proxy *feda_peer_get_proxy_object(const struct feda_peer *fp);

const char *feda_peer_description(const struct feda_peer *fp);

void choose_peers_for_natcheck(struct feda_pir_collection *pir, int stubcred,
                               struct feda_peer *peers[10], int *num);

    /* returns packet size >= 40 if it is ready, otherwise returns 0;
       caller may assume all reports are already done */
int feda_peer_handle_traffic(struct feda_peer *fp,
                             const unsigned char *packet, int packetsize,
                             unsigned char *buf, int bufsize);

#endif
