#ifndef FSRV_PAD_H_SENTRY
#define FSRV_PAD_H_SENTRY

/* This module is named after packet assebler/disassembler a.k.a. PAD.
   Despite its name, it only carries out assembly of incoming (fragmented)
   packets.  It should ONLY be used by the fsrv_rx module; ideas of
   anything else are bad.
 */


struct feda_peer_defrag;


    /* seq_bits determine how many packet slots there will be;
       the actual count of the slots is seq_bits' power of two,
       e.g., for seq_bits==8 there will be 256 slots for packets
       being assembled, effectively meaning that the 8 less
       significant bits are taken from each packet's sequence
       number to determine the slot's number it will use; in case
       the slot is still occupied, the previous packet is dropped
     */
struct feda_peer_defrag *make_peer_defrag(int seq_bits);
void dispose_peer_defrag(struct feda_peer_defrag *fpd);


enum {
    fpdstat_go_on            =  0,  /* more parts to wait for */
    fpdstat_dropped_this     = -1,  /* duplicate num, nothing changed */
    fpdstat_dropped_earlier  = -2,  /* earlier (incomplete) pack dropped */
    fpdstat_buffer_short     = -3   /* enlarge the buffer, try again */
};

    /* returns fpdstat_* or (for the success) the packet size, > 0 */
int peer_defrag_proc(struct feda_peer_defrag *fpd,
                     const unsigned char *packet, int packetsize,
                     unsigned char *buf, int bufsize);

#endif
