#include <stdlib.h>
#include <string.h>  /* for memcpy, exclusively */

#include "servlog.h"
#include "fsrv_pad.h"


struct defrag_slot {
    int seqnum;
    int expected_frags;
    unsigned char *frags[4];
    short int sizes[4];
};

struct feda_peer_defrag {
    int slot_count, slot_power;
    struct defrag_slot *slots;
};


#if 0
static void defrag_slot_init(struct defrag_slot *p)
{
    memset(p, 0, sizeof(*p));
    p->seqnum = -1;
}
#endif

static void defrag_slot_clean(struct defrag_slot *p)
{
    int i;
    for(i = 0; i < 4; i++)
        if(p->frags[i]) {
            free(p->frags[i]);
            p->frags[i] = NULL;
        }
    p->seqnum = -1;
}

struct feda_peer_defrag *make_peer_defrag(int seq_bits)
{
    struct feda_peer_defrag *res;
    int sz, i;

    res = malloc(sizeof(*res));
    res->slot_count = (1 << seq_bits);
    res->slot_power = seq_bits;
    sz = res->slot_count * sizeof(*res->slots);
    res->slots = malloc(sz);
    memset(res->slots, 0, sz);
    for(i = 0; i < res->slot_count; i++)
        res->slots[i].seqnum = -1;
    return res;
}

void dispose_peer_defrag(struct feda_peer_defrag *fpd)
{
    int i;

    for(i = 0; i < fpd->slot_count; i++)
        defrag_slot_clean(fpd->slots + i);
    free(fpd->slots);
    free(fpd);
}

static int is_the_last(const struct defrag_slot *slot, int num)
{
    int i;
    for(i = 0; i < slot->expected_frags; i++)
        if(i == num ? !!slot->frags[i] : !slot->frags[i])
            return 0;
    return 1;
}

int peer_defrag_proc(struct feda_peer_defrag *fpd,
                     const unsigned char *packet, int packetsize,
                     unsigned char *buf, int bufsize)
{
    int tot, num, seqnum, slotnum;
    struct defrag_slot *slot;

    tot = (packet[0] >> 2) & 0x03;
    num = packet[0] & 0x03;

    seqnum = ((int)packet[1] << 16) | ((int)packet[2] << 8) | packet[3];
    slotnum = seqnum & (fpd->slot_count - 1);
    slot = fpd->slots + slotnum;

    servlog_message(srvl_debug2, "cmdbyte %02X (%d/%d) seq %d slotnum %d; %s",
                                 packet[0], num, tot, seqnum, slotnum,
                                 tot == 0 ? "singleton" : "fragmented");

    if(tot == 0) {  /* very special case, we don't need a slot here */
        if(bufsize < packetsize - 4)
            return fpdstat_buffer_short;
        memcpy(buf, packet + 4, packetsize - 4);
        return packetsize - 4;
    }

    if(slot->seqnum != seqnum) {        /* the first dgram */
        int dropped = slot->seqnum != -1;
        if(dropped)
            defrag_slot_clean(slot);
        slot->seqnum = seqnum;
        slot->expected_frags = tot + 1;
        slot->sizes[num] = packetsize - 4;
        slot->frags[num] = malloc(packetsize - 4);
        memcpy(slot->frags[num], packet + 4, packetsize - 4);
        return dropped ? fpdstat_dropped_earlier : fpdstat_go_on;
    }

    if(is_the_last(slot, num)) { /* build it w/o copying */
        int offset, i;
        offset = 0;
        for(i = 0; i < slot->expected_frags; i++) {
            if(i == num) {
                memcpy(buf + offset, packet + 4, packetsize - 4);
                offset += (packetsize - 4);
            } else {
                memcpy(buf + offset, slot->frags[i], slot->sizes[i]);
                offset += slot->sizes[i];
            }
        }
        defrag_slot_clean(slot);
        return offset;
    }

    if(slot->frags[num])     /* duplicate dgram? anyway, won't replace */
        return fpdstat_dropped_this;

    /* okay, memorize the fragment */

    slot->sizes[num] = packetsize - 4;
    slot->frags[num] = malloc(packetsize - 4);
    memcpy(slot->frags[num], packet + 4, packetsize - 4);

    return fpdstat_go_on;
}

