#ifndef FSRV_DST_H_SENTRY
#define FSRV_DST_H_SENTRY

#include "fsrv_rep.h"

struct feda_peer;

struct feda_destination_map;

enum {
    ncstat_unknown,
    ncstat_present,
    ncstat_absent
};

struct destination_node {
    unsigned char node_id[node_id_size];
    char node_cert_status;      /*  ncstat_*  */
    char home_node;             /*  boolean   */
    struct feda_peer *node_peer; 
    struct feda_peer **point_peers; 
};

#define FEDA_DEST_IS_LOCAL     ((struct feda_peer*)3)
    /* must always be expected in destination_node fields as well as
       a value returned from the choose_dest_peer */

#define FEDA_DEST_NO_NODE      ((struct feda_peer*)5)
#define FEDA_DEST_NO_NODE_CERT ((struct feda_peer*)7)
#define FEDA_DEST_NO_POINT     ((struct feda_peer*)9)

struct feda_destination_map *make_destination_map();


    /* called when a crypto association is established or gone;
       fp == NULL means 'gone'
     */
void set_destination_peer(struct feda_destination_map *map,
                          const unsigned char *node_id, int point,
                          struct feda_peer *fp);

    /* fp == NULL means 'gone' */
void destmap_set_nodenets_peer(struct feda_destination_map *map,
                               struct feda_peer *fp, int fe_too);

struct destination_node *find_destination_node(struct feda_destination_map *m,
                                               const unsigned char *node_id);

#if 0  /* it is static now */
struct feda_peer *choose_dest_peer(struct destination_node *dn, int point);
#endif


struct feda_peer *find_dest_peer(struct feda_destination_map *map,
                                 const unsigned char *node_id, int point);


    /* picks no more than max nodes from the map, having the given prefix,
       and places their IDs in the nodes array; in case there are more than
       max of them, the first (max-1) are stored at nodes[0]...nodes[max-2],
       and the last (!) is stored at nodes[max-1].  Returns the total
       count of the suitable nodes, which may be (far) more than max.
     */
int destmap_choose_nodes(struct feda_destination_map *map,
                         const unsigned char *pref, int preflen,
                         unsigned char (*nodes)[node_id_size], int max);

    /* preflen is in HALFbytes! */
void destmap_report(struct feda_destination_map *map,
                    const unsigned char *pref, int preflen,
                    report_callback f, void *userdata);

    /* preflen is in HALFbytes! */
void destmap_streamrep(struct feda_destination_map *map,
                       const unsigned char *pref, int preflen, void *stream);

void destmap_pointrep(struct feda_destination_map *map,
                      const unsigned char *nid, int point,
                      report_callback f, void *userdata);

void destmap_stream_pointrep(struct feda_destination_map *map,
                      const unsigned char *nid, int point, void *stream);

#endif
