#ifndef FSRV_CFG_H_SENTRY
#define FSRV_CFG_H_SENTRY

#include "cryptodf.h"

enum peer_types {   /* two's powers! */
    ptp_default    = 0x0001,
    ptp_mynode     = 0x0002,
    ptp_natcheck   = 0x0004,
    ptp_persist    = 0x0008,
    ptp_nodenets   = 0x0010,
    ptp_trustncc   = 0x0020,
    ptp_certhub    = 0x0040,
    ptp_introducer = 0x0080,
    ptp_proxy      = 0x0100,
    ptp_proxyuser  = 0x0200,
    ptp_direct     = 0x0400
};

const char *peer_type_str(int ptp);

enum { peer_name_length_limit = 63 };

struct peer_conf {
    char name[peer_name_length_limit + 1];
    int type;
    unsigned int ip;
    unsigned short port;
    unsigned char node_id[node_id_size];
    int point;
    int proxyport;    /* proxyuser type only; -1 = undef, 0 = arbitrary */

    struct peer_conf *next;
};

#define PEER_IP_UNDEF ((unsigned int)(-1))
#define PEER_POINT_UNDEF (-1)

int peer_conf_has_ip(const struct peer_conf *pc);
int peer_conf_has_point(const struct peer_conf *pc);

enum {
    nodenets_none = 0,
    nodenets_some = 1,
    nodenets_all  = 2
};

struct server_conf_info {
    int log_syslog_level;
    int log_syslog_priv;
    int log_syslog_facility;
    char *log_syslog_ident;
    int log_file_level;
    int log_file_priv;
    char *log_file_name;
    int log_stderr_level;
    int log_stderr_priv;

    unsigned long listen_address;
    int listen_port;

    char *keys_dir;

    int control_socket;
    char *control_socket_path;

    int cooldown_timeout, peer_timeout, keepalive_interval;
    struct peer_conf *first_peer;

    int forwarding;
    char *tun_iface;
    int nodenets;
};

struct server_conf_info *make_servconf();
void dispose_servconf(struct server_conf_info *p);

int read_config(const char *fname, struct server_conf_info *p);

void settle_localpath(char **target, const char *localpath);
void settle_keydir(struct server_conf_info *p);
void settle_ctlsockpath(struct server_conf_info *p);

#endif
