#include <string.h>

#include "keyutils.h"
#include "hexdata.h"
#include "addrport.h"
#include "servlog.h"
#include "fsrv_rep.h"
#include "fsrv_cfg.h"

#include "fsrv_cfd.h"




static const char *strprot(const char *s)
{
    return s ? s : "(unset)";
}

static const char *node_id_string(const unsigned char ni[])
{
    static char s[node_id_size * 2 + 1];
    if(all_zeroes(ni, node_id_size))
        return "unknown";
    hexdata2str(s, ni, node_id_size);
    return s;
}

static void
do_dump_configuration(report_callback f, void *ud, struct server_conf_info *ci)
{
    struct peer_conf *p;
    int port = ci->listen_port;
    int useif;

    f(ud, "log_syslog level %d priv %d facilily %d ident %s",
          ci->log_syslog_level, ci->log_syslog_priv, ci->log_syslog_facility,
          strprot(ci->log_syslog_ident));
    f(ud, "log_file level %d priv %d name %s",
          ci->log_file_level, ci->log_file_priv, strprot(ci->log_file_name));
    f(ud, "log_stderr level %d priv %d",
          ci->log_stderr_level, ci->log_stderr_priv);
    f(ud, "listen_address/port %s (%x)",
          ipport2a(ci->listen_address, port), port);
    f(ud, "cooldown/peer timeouts %d/%d",
          ci->cooldown_timeout, ci->peer_timeout);
    f(ud, "keys_dir %s", strprot(ci->keys_dir)); 

    f(ud, "control socket is %sabled", ci->control_socket ? "en" : "dis"); 
    if(ci->control_socket)
        f(ud, "control socket path: %s", strprot(ci->control_socket_path)); 

    for(p = ci->first_peer; p; p = p->next) {
        static char typestr[128];
        int n;
        typestr[0] = 0;
        typestr[1] = 0;  /* for the case of empty set to not fail */
        for(n = 1; n <= 0x10000000; n *= 2) {
            if(p->type & n) {
                strcat(typestr, " ");
                strcat(typestr, peer_type_str(n));
            }
        }
        f(ud, "peer %s: type %x (%s) ip %s node %s point %d",
              p->name, p->type, typestr+1, ipport2a(p->ip, p->port),
              node_id_string(p->node_id), p->point);
    }

    useif = ci->forwarding && ci->tun_iface;
    f(ud, "forwarding %s%s%s", ci->forwarding ? "enabled" : "disabled",
                               useif ? ", tunnel iface " : "",
                               useif ? ci->tun_iface : "");
    if(useif) {
        switch(ci->nodenets) {
        case nodenets_none:
            break;
        case nodenets_some:
            f(ud, "we're the destination for the nets 00 and FF");
            break;
        case nodenets_all:
            f(ud, "we're the destination for the nets 00, FE and FF");
            break;
        }
    }
}


void dump_configuration_to_log(struct server_conf_info *ci, int level)
{
    do_dump_configuration(report_to_log_cb, &level, ci);
}

void dump_configuration_to_stream(struct server_conf_info *ci, FILE *stream)
{
    do_dump_configuration(report_to_stream_cb, stream, ci);
}


