#include "message.h"
#include "textrec.h"
#include "textrecx.h"
#include "kfiles.h"
#include "pointcfg.h"

#include "fk_diags.h"


void kfiles_message(int prio, int code, const char *fname, int errline)
{
    switch(code) {
    case kfiles_res_cant_open_file:
        message_perror(prio, "kfiles", fname);
        break;
    case textrecx_res_unknown_field:
    case textrecx_res_duplicate_field:
    case textrecx_res_mandatory_missing:
    case textrecx_res_incorrect_blob_size:
    case textrec_res_unfinished_line:
    case textrec_res_no_line_to_continue:
    case textrec_res_incorrect_blob_data:
    case textrec_res_incorrect_integer:
    case textrec_res_incorrect_boolean:
        message(prio, "%s:%d: %s\n", fname, errline,
                      kfiles_ctx_error_message(code));
        break;
    default:
        message(prio, "STRANGE: %s\n", kfiles_ctx_error_message(code));
    }
}

void pointcfg_message(int prio, int code, const char *fname, int errline)
{
    switch(code) {
    case rcf_res_cant_open_file:
        message_perror(prio, "kfiles", fname);
        break;
    case rcf_res_unknown_field:
    case rcf_res_incorrect_blob_size:
    case textrec_res_unfinished_line:
    case textrec_res_no_line_to_continue:
    case textrec_res_incorrect_blob_data:
    case textrec_res_incorrect_integer:
    case textrec_res_incorrect_boolean:
        message(prio, "%s:%d: %s\n", fname, errline, rcf_error_message(code));
        break;
    default:
        message(prio, "STRANGE: %s\n", rcf_error_message(code));
    }
}
