#ifndef FK_DATA_H_SENTRY
#define FK_DATA_H_SENTRY

#include "cryptodf.h"
#include "keyutils.h"
#include "kfiles.h"    /* the shortest way to compatibility */



/* ==== master file (generated by feda-ng) ============== */

struct master_file {
    unsigned char node_id[node_id_size];  /* just "id" in the file */
    int preflen;
    unsigned char secret[secret_key_size];
    unsigned char public_key[public_key_size];
    unsigned char yeshash[yespower_hash_size];
};

    /* returns boolean value */
int read_master_file(const char *name, struct master_file *data);




/* ==== point information file ========================== */

/* data stored in a file used to deploy a point; please note in FEDAnet
   only first- and second-level certificates are used; first-level certs
   are signed with the master key of the node and are trusted as long as
   the node_id matches the public key _and_ the yespower hash's FEDA
   prefix is long enough; second-level certs are signed by the Point Zero
   and are trusted as long as their node's key is trusted and they have
   a valid first-level certificate.
 */
struct point_file {
    unsigned char node_id[node_id_size];
    int point;
    int rank;
    int minpref;
    unsigned char secret[secret_key_size];
    unsigned char public_key[public_key_size];  /* "public" */
    int signed_by; /* -1 means master, 0 means Zero Point */
    unsigned char master_pub[public_key_size];
    unsigned char master_hash[yespower_hash_size];
    unsigned char master_hsign[signature_size];
    int timestamp;
    unsigned char certbody[feda_cert_size];
    unsigned char signature[signature_size];
       /* the following fields are to be zero-filled if signed_by == -1 */
    unsigned char zp_pub[public_key_size];
    unsigned char zp_certbody[feda_cert_size];
    unsigned char zp_signature[signature_size];
};

    /* returns boolean value */
int read_point_file(const char *name, struct point_file *data);



/* ==== kex keypair file ================================ */

struct kex_keypair_file {
    int created, replaced;   /* timemarks */
    unsigned char kex_secret[kex_secret_size];
    unsigned char kex_public[kex_public_size];
};

    /* returns boolean value */
int read_kex_keypair_file(const char *name, struct kex_keypair_file *data,
                          int suppress_messages);



/* ==== point certificate file ========================== */

struct point_cert_file {
    unsigned char node_id[node_id_size];
    int rank;
    int point;
    int signed_by;
    unsigned char public_key[public_key_size];  /* "public" */
    unsigned char master_pub[public_key_size];
    unsigned char master_hash[yespower_hash_size];
    unsigned char master_hsign[signature_size];
        /* zp_* are all-zero for certs signed directly by the master,
           and should be omitted from the actual file */
    unsigned char zp_certbody[feda_cert_size];
    unsigned char zp_signature[signature_size];
    unsigned char certbody[feda_cert_size];
    unsigned char signature[signature_size];
    unsigned char kex_public[kex_public_size];
    unsigned char kex_cert[feda_kex_info_size];
    unsigned char kex_signature[signature_size];
    int kex_timestamp;
};

    /* returns boolean value */
int read_pointcert_file(const char *name, struct point_cert_file *data);

    /* doesn't clear the *data, unlike read_pointcert_file */
    /* returns boolean value */
int read_from_pointcert_file(const char *name, struct point_cert_file *data);


#endif
