#include "fedapref.h"

int feda_prefix_len(const unsigned char *buf, int len)
{
    static const char pattern[2] = { 0xfe, 0xda };
    int bits = 0;
    unsigned char c;
    int idx;
    for(idx = 0; idx < len; idx++) {
        c = buf[idx] ^ pattern[idx & 1];
        if(c) {
            int n = 0;
            while(c) {
                c >>= 1;
                n++;
            }
            bits = 8 - n;
            break;
        }
    }
    return idx * 8 + bits;
}

