#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>



/* copied from the fsrv_cfg module, 1:1; should perhaps reside elsewhere
   (in fileutils.[ch]?)
 */
static void settle_localpath(char **target, const char *localpath)
{
    const char *home;
    char *dir;
    int homelen, lplen;

    if(*target)
        return;

    home = getenv("HOME");
    if(!home || !*home) {  /* rare case; fallback to the current directory */
        *target = strdup(localpath);
        return;
    }
    homelen = strlen(home);
    lplen = strlen(localpath);
    dir = malloc(homelen + 1 + lplen + 1);
    strcpy(dir, home);
    dir[homelen] = '/';
    strcpy(dir + homelen + 1, localpath);
    *target = dir;
}

static int bring_up(const char *path)
{
    int sd, r, len;
    struct sockaddr_un sun;

    len = strlen(path);
    if(len + 1 > sizeof(sun.sun_path)) {
        fprintf(stderr, "socket path too long [%s]\n", path);
        return -1;
    }
    sd = socket(AF_UNIX, SOCK_STREAM, 0);
    if(!sd) {
        perror(path);
        return -1;
    }

    sun.sun_family = AF_UNIX;
    strcpy(sun.sun_path, path);

    r = connect(sd, (struct sockaddr*)&sun, sizeof(sun));
    if(r == -1) {
        perror(path);
        close(sd);
        return -1;
    }

    return sd;
}

static void iftransfer(int src, int target, fd_set *set, int *have_eof)
{
    static char buf[4096];
    int r;
    if(!FD_ISSET(src, set))
        return;
    r = read(src, buf, sizeof(buf));
    if(r == -1)
        perror("read");
    if(r < 1) {
        *have_eof = 1;
        return;
    }
    write(target, buf, r);
}

static void main_loop(int sfd)
{
    fd_set rfds;
    int r, have_eof;
    for(;;) {
        FD_ZERO(&rfds);
        FD_SET(0, &rfds);
        FD_SET(sfd, &rfds);
        r = select(sfd+1, &rfds, NULL, NULL, NULL);
        if(r == -1) {
            perror("select");
            return;
        }
        have_eof = 0;
        iftransfer(0, sfd, &rfds, &have_eof);
        iftransfer(sfd, 1, &rfds, &have_eof);
        if(have_eof)
            return;
    }
}

int main(int argc, char **argv)
{
    char *sp;
    int fd;

    sp = argc > 1 ? argv[1] : NULL;
    if(sp && *sp == '-') {
        printf("Usage: fedactl [<socket_path>]\n"
               "You might want to launch this with rlwrap\n");
        return 0;
    }
    settle_localpath(&sp, ".fedanet/servctl");

    fd = bring_up(sp);
    if(fd == -1)
        return 1;

    main_loop(fd);
    return 0;
}
