#ifndef CRYPTODF_H_SENTRY
#define CRYPTODF_H_SENTRY

enum {
    seed_size = 32,
    secret_key_size = 64,
    public_key_size = 32,
    signature_size = 64,
    yespower_hash_size = 32,
    yespower_param_r_value = 32,
    yespower_param_n_value = 65536,
    kex_secret_size = 32,
    kex_public_size = 32,
    shared_secret_size = 32,
    cipher_key_size = 32,

    cipher_mac_size = 16,
    cipher_nonce_total = 24,
    cipher_nonce_used = 8,
    cipher_nonce_offset = cipher_nonce_total - cipher_nonce_used,

    node_id_size = 10,
    base32_id_max = 16,  /* node_id_size * 8 / 5 */

    minrank_min = 8,
    minrank_max = 48,

    max_point_number = 255
};

typedef unsigned char u_chr;     /* hope this won't conflict with anything */


#endif
