#ifndef COMCRYPT_H_SENTRY
#define COMCRYPT_H_SENTRY


#include "cryptodf.h"


struct point_config_file;
                    /* defined in pointcfg.h; see comcryp2.c for details */

struct crypto_comm_context {
    unsigned char kex_secret[kex_secret_size];
    unsigned char kex_public[kex_public_size];
    unsigned char nonce_counter[cipher_nonce_used];
    unsigned char point_secret[secret_key_size];
    struct point_config_file *point;
};

    /* returns boolean */
int comctx_init(struct crypto_comm_context *p);

void comctx_fill_nonce(struct crypto_comm_context *p, unsigned char *buf);

    /* returns boolean; implemented in comcryp2.c */
int cpmctx_init_point(struct crypto_comm_context *p, const char *dir);



    /* either of {en,de}crypt_key may be NULL */
void derive_cipher_keys(const unsigned char *local_secret,
                        const unsigned char *local_pub_key,
                        const unsigned char *remote_pub_key,
                        unsigned char *encrypt_key,
                        unsigned char *decrypt_key);


            /* 64 is 8+16+40, for nonce, mac and an "empty" IPv6 packet;
               all "protocol/service" dgrams are padded */
enum {
    fedaprot_min_dgram    = 64,         /* single datagram size limits */
    fedaprot_max_dgram    = 508,
    fedaprot_min_payload  = 40,

    fedaprot_zb_maxverb   = 0xBF,       /* Zero Byte value margins */
    fedaprot_zb_minenc    = 0xC0,
    fedaprot_zb_maxenc    = 0xDF,
    fedaprot_zb_minplain  = 0xE0,
    fedaprot_zb_maxplain  = 0xFF,

    fedaprot_intro_req    = 0x14,       /* plain dgram types */
    fedaprot_i_am         = 0x1A,
    fedaprot_associate    = 0xA5,
    fedaprot_change_key   = 0xC4,
    fedaprot_stub         = 0x57,
    fedaprot_test         = 0x7E,
    fedaprot_test_reply   = 0x7F,
    fedaprot_error        = 0xE8,
    fedaprot_echo_req     = 0xEC,
    fedaprot_echo_reply   = 0xED,
    fedaprot_forward      = 0xF0,

    fedaprot_cr_keepalive = 0x03,       /* fully encrypted dgram types */
    /* fedaprot_cr_plzask    = 0x0A, */
    fedaprot_cr_plzcont   = 0x0C,
    fedaprot_cr_error     = 0x0E,
    fedaprot_cr_nodect_q  = 0x8C,
    fedaprot_cr_nodect_re = 0x9C,
    fedaprot_cr_pxy_outb  = 0xB0,
    fedaprot_cr_pxy_inb   = 0xB1,

       /* error codes */

    fedaprot_err_unexpected  = 0x01,  /* cmd code known, but unexpected */
    fedaprot_err_unknown     = 0x02,  /* cmd code unknown */
    fedaprot_err_broken      = 0x03,  /* broken dgram (too short?) */
    fedaprot_err_kex_refused = 0x04,  /* we refuse to replace kex key   */
    fedaprot_err_no_assoc    = 0x05,  /* crypro dgram from unkn. source */
    fedaprot_err_decrypt     = 0x06,  /* failed to decrypt */
    fedaprot_err_signature   = 0x07,  /* signature check failed */
    fedaprot_err_node_unkn   = 0x08,  /* node unknown, introduce yourself */
    fedaprot_err_rank_low    = 0x09,  /* your rank is too low */
    fedaprot_err_unexp_point = 0x0A,  /* didn't expect you at this ip:port */
    fedaprot_err_wont_proxy  = 0x0B,  /* you're not conf'd as a proxy user */
    fedaprot_err_internal    = 0x0f,  /* internal error */

};

const char *fedaprot_err_diags(int code);

void set_plain_dgram_head(unsigned char *dgram, int cmd);

int get_plain_dgram_cmd(const unsigned char *dgram);


#endif
