#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>

#include <monocypher/monocypher.h>

#include "keyutils.h"
#include "comcrypt.h"

int comctx_init(struct crypto_comm_context *p)
{
    int res;

    res = get_random(p->kex_secret, sizeof(p->kex_secret));
    if(!res)
        return 0;

    crypto_x25519_public_key(p->kex_public, p->kex_secret);

    fill_noise(p->nonce_counter, sizeof(p->nonce_counter));
    p->nonce_counter[sizeof(p->nonce_counter)-1] = 1;
        /* so we can more or less be sure it will never overflow */

    memset(p->point_secret, 0, secret_key_size);

    p->point = NULL;
    return 1;
}

void comctx_fill_nonce(struct crypto_comm_context *p, unsigned char *buf)
{
    increment_buf(p->nonce_counter, sizeof(p->nonce_counter));
    memcpy(buf, p->nonce_counter, sizeof(p->nonce_counter));
}


#if 0
    struct config_file *cfp;
    cpf = malloc(sizeof(*cfp));
#endif


void derive_cipher_keys(const unsigned char *local_secret,
                        const unsigned char *local_pub_key,
                        const unsigned char *remote_pub_key,
                        unsigned char *encrypt_key,
                        unsigned char *decrypt_key)
{
    unsigned char s[shared_secret_size + 2*kex_public_size];
    unsigned char *shared_secret = s + 2*kex_public_size;

    crypto_x25519(shared_secret, local_secret, remote_pub_key);

    if(encrypt_key) {
        memcpy(s,                 remote_pub_key, kex_public_size);
        memcpy(s+kex_public_size, local_pub_key,  kex_public_size);
        crypto_blake2b(encrypt_key, cipher_key_size, s, sizeof(s));
    }

    if(decrypt_key) {
        memcpy(s,                 local_pub_key,  kex_public_size);
        memcpy(s+kex_public_size, remote_pub_key, kex_public_size);
        crypto_blake2b(decrypt_key, cipher_key_size, s, sizeof(s));
    }

    crypto_wipe(s, sizeof(s));
}


const char *fedaprot_err_diags(int code)
{
    switch(code) {
    case fedaprot_err_unexpected:  return "cmd code known but unexpected";
    case fedaprot_err_unknown:     return "cmd code unknown";
    case fedaprot_err_broken:      return "broken dgram (too short?)";
    case fedaprot_err_kex_refused: return "we refuse to replace kex key";
    case fedaprot_err_no_assoc:    return "crypro dgram from unkn. source";
    case fedaprot_err_decrypt:     return "failed to decrypt";
    case fedaprot_err_signature:   return "signature check failed";
    case fedaprot_err_node_unkn:   return "node unknown, introduce yourself";
    case fedaprot_err_rank_low:    return "your rank is too low";
    case fedaprot_err_wont_proxy:  return "you're not my proxy user";
    case fedaprot_err_internal:    return "internal error";
    default:                       return "UNKNOWN error code";
    }
}

void set_plain_dgram_head(unsigned char *dgram, int cmd)
{
    unsigned char uc;

    dgram[0] = rand_from_range(fedaprot_zb_minplain, fedaprot_zb_maxplain);
    uc = dgram[0] & 0x0f;
    uc |= (uc << 4) & 0xf0;
    dgram[1] = cmd ^ uc;
}

int get_plain_dgram_cmd(const unsigned char *dgram)
{
    unsigned char uc;

    if(*dgram < 0xE0)
        return -1;

    uc = (dgram[0] & 0x0f) | ((dgram[0] << 4) & 0xf0);
    return dgram[1] ^ uc;
}
