/* This file implements reading local point's information, which is not
   needed for purely client programs such as natcheck, but mandatory for
   the server.  Functions from here suck in a lot of object files related
   to key information handling.
 */

#include <stdlib.h>

#include <monocypher/monocypher.h>

#include "kfiles.h"
#include "pointcfg.h"
#include "servlog.h"
#include "fsrv_dia.h"

#include "comcrypt.h"


/* as of now, this module only used by the server, so it is okay to make it
   dependend on the servlog_* stuff */


int cpmctx_init_point(struct crypto_comm_context *p, const char *dir)
{
    int res, errline;
    char *secretkey_fname, *config_fname;

    secretkey_fname = make_secretkey_fname(dir);
    config_fname = make_config_fname(dir);

    if(p->point)
        free(p->point);

    p->point = malloc(sizeof(*p->point));

    res = read_config_file(config_fname, p->point, &errline);
    if(res != rcf_res_ok) {
        pointcfg_logmsg(srvl_normal, res, config_fname, errline);
        servlog_message(srvl_alert, "Couldn't get the point configuration\n");
        servlog_message(srvl_info, "do you have a point deployed here?\n");
        res = 0;
        goto quit;
    }

    res = read_single_blob(secretkey_fname, "secret",
                           p->point_secret, secret_key_size, &errline);
    if(res != kfiles_res_ok) {
        kfiles_logmsg(srvl_normal, res, config_fname, errline);
        servlog_message(srvl_alert,
                        "Couldn't get the point secret key, can't start\n");
        res = 0;
        goto quit;
    }

    res = 1;
quit:
    dispose_fname(config_fname);
    dispose_fname(secretkey_fname);
    if(!res) {
        free(p->point);
        p->point = NULL;
        crypto_wipe(p->point_secret, secret_key_size);
    }
    return res;
}
