#ifndef ADDRPORT_H_SENTRY
#define ADDRPORT_H_SENTRY



enum { addrport_max_string = 22 }; /* sizeof("111.111.111.111:55555") */


/* "mem" means 6 bytes (4 for ip + 2 for port), in MSBF (network) order */

void ipport2str(char *str, unsigned int ip, unsigned short port);

const char *ipport2a(unsigned int ip, unsigned short port);

void ipport2mem(unsigned char mem[6], unsigned int ip, unsigned short port);

void mem2ipport(const unsigned char mem[6],
                unsigned int *ip, unsigned short *port);

void ipport_mem2str(char *str, const unsigned char mem[6]);

const char *ipport_mem2a(const unsigned char mem[6]);


struct addrport {           /* always in host byte order! */
    unsigned int addr;
    unsigned short port;
};

void addrport2str(char *str, const struct addrport *ap);

const char *addrport2a(const struct addrport *ap);

void addrport2mem(unsigned char mem[6], const struct addrport *ap);

void mem2addrport(const unsigned char mem[6], struct addrport *ap);

#endif
