#include <stdio.h>

#include "addrport.h"


void ipport2str(char *str, unsigned int ip, unsigned short port)
{
    sprintf(str, "%d.%d.%d.%d:%d",
                 (int) ((ip >> 24) & 0xff),
                 (int) ((ip >> 16) & 0xff),
                 (int) ((ip >> 8)  & 0xff),
                 (int) (ip         & 0xff),
                 port);
}

const char *ipport2a(unsigned int ip, unsigned short port)
{
    static char str[addrport_max_string];
    ipport2str(str, ip, port);
    return str;
}

const char *addrport2a(const struct addrport *ap)
{
    return ipport2a(ap->addr, ap->port);
}

void addrport2str(char *str, const struct addrport *ap)
{
    ipport2str(str, ap->addr, ap->port);
}

void ipport2mem(unsigned char mem[6], unsigned int ip, unsigned short port)
{
    mem[0] = (ip >> 24)  & 0xff;
    mem[1] = (ip >> 16)  & 0xff;
    mem[2] = (ip >>  8)  & 0xff;
    mem[3] = ip          & 0xff;
    mem[4] = (port >> 8) & 0xff;
    mem[5] = port        & 0xff;
}

void ipport_mem2str(char *str, const unsigned char mem[6])
{
    struct addrport ap;
    mem2addrport(mem, &ap);
    addrport2str(str, &ap);
}

const char *ipport_mem2a(const unsigned char mem[6])
{
    static char str[addrport_max_string];
    ipport_mem2str(str, mem);
    return str;
}

void addrport2mem(unsigned char mem[6], const struct addrport *ap)
{
    ipport2mem(mem, ap->addr, ap->port);
}

void mem2ipport(const unsigned char mem[6],
                unsigned int *ip, unsigned short *port)
{
    *ip =
        ((unsigned int)mem[0] << 24) |
        ((unsigned int)mem[1] << 16) |
        ((unsigned int)mem[2] << 8)  |
        ((unsigned int)mem[3]);
    *port =
        ((unsigned int)mem[4] << 8)  |
        ((unsigned int)mem[5]);
}

void mem2addrport(const unsigned char mem[6], struct addrport *ap)
{
    mem2ipport(mem, &ap->addr, &ap->port);
}

